
using System.Collections.Generic;
using System.Reflection;
using UnityEditor;
using UnityEditor.ShortcutManagement;
using UnityEngine;

public static class Shortcuts
{
    [Shortcut("Clear Console", KeyCode.C, ShortcutModifiers.Alt)]
    public static void ClearConsole()
    {
        var assembly = Assembly.GetAssembly(typeof(SceneView));
        var type = assembly.GetType("UnityEditor.LogEntries");
        var method = type.GetMethod("Clear");
        method.Invoke(new object(), null);        
    }
    
    [Shortcut("Edit/Remove Auto-Name", KeyCode.D, ShortcutModifiers.Control | ShortcutModifiers.Shift)]
    public static void RemoveFromSelection() {
        RemoveFromObjects(Selection.gameObjects);
    }

    public static void RemoveFromObjects(params GameObject[] objects) {
        foreach(var selectedObject in objects) {
            string objName = selectedObject.name;
            char lastChar = objName[objName.Length - 1];
            int indexOfAddedString = objName.LastIndexOf(" (");
            int uniqueNumberLength = objName.Length - (indexOfAddedString + 3);
            string uniqueNumberString = objName.Substring(indexOfAddedString + 2, uniqueNumberLength);
            int uniqueNumber;
            if(lastChar == ')' && indexOfAddedString != -1 && int.TryParse(uniqueNumberString, out uniqueNumber)) {
                Undo.RecordObject(selectedObject, "Remove Auto-Name");
                selectedObject.name = objName.Substring(0, indexOfAddedString);
            }
        }
    }
    
    private static int _lengthOfAddedString = "(Clone)".Length;
    private static List<int> _selection = new List<int>();
    
    [Shortcut("Edit/Duplicate Without Auto-Name", KeyCode.D, ShortcutModifiers.Alt)]
    public static void DeselectEverything() {
        foreach(var selectedObject in Selection.gameObjects) {
            var newGo = GameObject.Instantiate(selectedObject, selectedObject.transform.parent);
            newGo.name = newGo.name.Substring(0, newGo.name.Length - _lengthOfAddedString);
            _selection.Add(newGo.GetInstanceID());
        }

        Selection.instanceIDs = _selection.ToArray();
        _selection.Clear();
    }
}