using System.Collections;
using System.Collections.Generic;
using UnityEditor;
using UnityEngine;

public class ImportSettingsEditorWindow : EditorWindow
{
    public static void ShowWindow()
    {
        ImportSettingsEditorWindow wnd = CreateInstance<ImportSettingsEditorWindow>();
        wnd.Show();
    }

    private void OnGUI()
    {
        GUIStyle headerStyle = new GUIStyle(EditorStyles.label);
        headerStyle.fontSize = 20;

        EditorGUILayout.LabelField("Volume rendering import settings", headerStyle);
        EditorGUILayout.Space();

        EditorGUILayout.LabelField("Show promt asking if you want to downscale the dataset on import?");
        bool showDownscalePrompt = EditorGUILayout.Toggle("Show downscale prompt", EditorPrefs.GetBool("DownscaleDatasetPrompt"));
        EditorPrefs.SetBool("DownscaleDatasetPrompt", showDownscalePrompt);

        EditorGUILayout.Space();
        EditorGUILayout.Space();

        EditorGUILayout.LabelField("SimpleITK", headerStyle);
        EditorGUILayout.Space();
        EditorGUILayout.LabelField("SimpleITK is a library that adds support for JPEG-compressed DICOM, as well as NRRD and NIFTI formats.\n" +
                                   "Supported platforms: Windows, Linux, MacOS.\n" +
                                   "You may want to add the Assets/3rdparty/SimpleITK folder to your .gitignore, as the binary is is >100MB", EditorStyles.wordWrappedLabel);

        if (SimpleITKManager.IsSITKEnabled() && !SimpleITKManager.HasDownloadedBinaries())
        {
            Debug.LogWarning("SimpleITK is enabled despite not being downloaded. Disabling SimpleITK.");
            SimpleITKManager.EnableSITK(false);
        } 
        
        if (GUILayout.Button("Download SimpleITK"))
        {
            SimpleITKManager.DownloadBinaries();
        }

        if (SimpleITKManager.HasDownloadedBinaries())
        {
            string buttonText = SimpleITKManager.IsSITKEnabled() ? "Disable SimpleITK" : "Enable SimpleITK";
            if (GUILayout.Button(buttonText))
            {
                SimpleITKManager.EnableSITK(!SimpleITKManager.IsSITKEnabled());
            }
        }
    }
}
