using UnityEngine;
using UnityEditor;
using System.Collections.Generic;
using System.IO;

//purpose of this postprocessor is to ensure that listed file extensions
// are not in certain filepaths, when they are they are moved to a 
//specified default path
public class FileImportHandler : AssetPostprocessor
{
	//only evaluate files imported into these paths
	private static List<string> pathsToMoveFrom = new List<string>()
	{
		"Assets"
	};

	private static Dictionary<string, string> defaultFileLocationByExtension = new Dictionary<string, string>()
	{
		{".cs", "Assets/Scripts/"},

		{".unity", "Assets/Scenes/"},

		{".prefab", "Assets/Prefabs/"}, 

		{".wav",  "Assets/Audio/"},
		{".wave", "Assets/Audio/"},
		{".mp3",  "Assets/Audio/"},
		{".ogg",  "Assets/Audio/"},
		{".oga",  "Assets/Audio/"},
		{".mogg", "Assets/Audio/"},
		{".aiff", "Assets/Audio/"},
		{".flac", "Assets/Audio/"},
		{".m4a",  "Assets/Audio/"},
		{".aac",  "Assets/Audio/"},
		{".s3m",  "Assets/Audio/"},
		{".xm",   "Assets/Audio/"},
		{".it",   "Assets/Audio/"},
		{".mod",  "Assets/Audio/"},

		{".mixer", "Assets/Audio/Mixers/"},

		{".mid",  "Assets/Audio/Other/"},
		{".midi", "Assets/Audio/Other/"},

		{".fbx",    "Assets/Art/Models/"},
		{".blend",  "Assets/Art/Models/"},
		{".blend1", "Assets/Art/Models/"},
		{".obj",    "Assets/Art/Models/"},
		{".3ds",    "Assets/Art/Models/"},
		{".amf",    "Assets/Art/Models/"},
		{".gml",    "Assets/Art/Models/"},
		{".gltf",   "Assets/Art/Models/"},
		{".ply",    "Assets/Art/Models/"},
		{".usd",    "Assets/Art/Models/"},
		{".usdz",   "Assets/Art/Models/"},
		{".stl",    "Assets/Art/Models/"},
		{".iges",   "Assets/Art/Models/"},
		{".dae",    "Assets/Art/Models/"},
		{".dcc",    "Assets/Art/Models/"},
		{".3d",     "Assets/Art/Models/"},
		{".max",    "Assets/Art/Models/"},
		{".dxf",    "Assets/Art/Models/"},
		{".ma",     "Assets/Art/Models/"},
		{".mb",     "Assets/Art/Models/"},
		{".c4d",    "Assets/Art/Models/"},

		{".anim",       "Assets/Art/Animations/"},
		{".controller", "Assets/Art/Animations/"},

		{".ttf",   "Assets/Art/Fonts/"},
		{".otf",   "Assets/Art/Fonts/"},
		{".woff",  "Assets/Art/Fonts/"},
		{".woff2", "Assets/Art/Fonts/"},
		{".odtff", "Assets/Art/Fonts/"},
		{".ttc",   "Assets/Art/Fonts/"},

		{".mat",         "Assets/Art/Materials/"},
		{".shadergraph", "Assets/Art/Materials/"},
		{".sbsar",       "Assets/Art/Materials/"},
		{".shader",      "Assets/Art/Materials/"},
		{".cginc",       "Assets/Art/Materials/"},

		{".bmp",  "Assets/Art/Images/"},
		{".png",  "Assets/Art/Images/"},
		{".jpg",  "Assets/Art/Images/"},
		{".jpeg", "Assets/Art/Images/"},
		{".psd",  "Assets/Art/Images/"},
		{".kra",  "Assets/Art/Images/"},
		{".gif",  "Assets/Art/Images/"},
		{".tif",  "Assets/Art/Images/"},
		{".tiff", "Assets/Art/Images/"},
		{".tga",  "Assets/Art/Images/"},
		{".pdf",  "Assets/Art/Images/"},
		{".svg",  "Assets/Art/Images/"},
	};

	static void OnPostprocessAllAssets(string[] importedAssets, string[] deletedAssets, string[] movedAssets, string[] movedFromAssetPaths)
	{
		foreach (string oldFilePath in importedAssets)
		{
			string directory = Path.GetDirectoryName(oldFilePath);
			if (!pathsToMoveFrom.Contains(directory))
				continue;

			string extension = Path.GetExtension(oldFilePath).ToLower();
			if (!defaultFileLocationByExtension.ContainsKey(extension))
				continue;

			string filename = Path.GetFileName(oldFilePath);
			string newPath = defaultFileLocationByExtension[extension];

			AssetDatabase.MoveAsset(oldFilePath, newPath + filename);


			Debug.Log($"Moving asset ({filename}) to path: {newPath}");
		}
	}
}