using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using Unity.Mathematics;

public class Util
{
    public static IEnumerable<uint3> EnumerateIndices(uint3 start, uint3 end)
    {
        for (var z = start.z; z < end.z; ++z)
        {
            for (var y = start.y; y < end.y; ++y)
            {
                for (var x = start.x; x < end.x; ++x)
                {
                    yield return new uint3(x, y, z);
                }
            }
        }
    }

    public static IEnumerable<int3> EnumerateIndices(int3 start, int3 end)
    {
        for (var z = start.z; z < end.z; ++z)
        {
            for (var y = start.y; y < end.y; ++y)
            {
                for (var x = start.x; x < end.x; ++x)
                {
                    yield return new int3(x, y, z);
                }
            }
        }
    }
}