using UnityEngine;

// Store all shader indices to save runtime cost for string lookup on every sample
public struct ShaderIndices
{
    public readonly int TraceKernel;
    public readonly int ClearResultKernel;
    public readonly int Result;
    public readonly int DepthTexture;
    public readonly int ShowEnvironment;
    public readonly int Seed;
    public readonly int CurrentSample;
    public readonly int Bounces;

    public readonly int CameraToWorld;
    public readonly int CameraInvProj;

    public readonly int VolumeDensityIndirection;
    public readonly int VolumeDensityRange;
    public readonly int VolumeDensityAtlas;
    public readonly int VolumeMinorant;
    public readonly int VolumeMajorant;
    public readonly int VolumeInverseMajorant;
    public readonly int VolumeAlbedo;
    public readonly int VolumePhaseG;
    public readonly int VolumeDensityScale;
    public readonly int VolumeBBMin;
    public readonly int VolumeBBMax;
    public readonly int VolumeDensityTransform;
    public readonly int VolumeDensityInverseTransform;

    public readonly int MipRangeFixed;

    public readonly int TransferFunctionBufferLut;
    public readonly int TransferFunctionBufferSize;
    public readonly int TransferFunctionWindowLeft;
    public readonly int TransferFunctionWindowWidth;

    public readonly int EnvironmentMap;
    public readonly int EnvironmentImportanceMap;
    public readonly int EnvironmentStrength;
    public readonly int EnvironmentImportanceInverseDimension;
    public readonly int EnvironmentImportanceBaseMip;

    public readonly int LightWorldPos;
    public readonly int LightWorldDir;

    public ShaderIndices(ComputeShader shader, bool includeKernels = true)
    {
        if (includeKernels && shader != null)
        {
            TraceKernel = shader.FindKernel("main");
            ClearResultKernel = shader.FindKernel("clear_result");
        }
        else
        {
            TraceKernel = 0;
            ClearResultKernel = 0;
        }

        Result = Shader.PropertyToID("result");
        DepthTexture = Shader.PropertyToID("depth_texture");
        ShowEnvironment = Shader.PropertyToID("show_environment");
        Seed = Shader.PropertyToID("seed");
        CurrentSample = Shader.PropertyToID("current_sample");
        Bounces = Shader.PropertyToID("bounces");

        CameraToWorld = Shader.PropertyToID("cam_to_world");
        CameraInvProj = Shader.PropertyToID("cam_inv_proj");

        VolumeDensityIndirection = Shader.PropertyToID("vol_density_indirection");
        VolumeDensityRange = Shader.PropertyToID("vol_density_range");
        VolumeDensityAtlas = Shader.PropertyToID("vol_density_atlas");
        VolumeMinorant = Shader.PropertyToID("vol_minorant");
        VolumeMajorant = Shader.PropertyToID("vol_majorant");
        VolumeInverseMajorant = Shader.PropertyToID("vol_inv_majorant");
        VolumeAlbedo = Shader.PropertyToID("vol_albedo");
        VolumePhaseG = Shader.PropertyToID("vol_phase_g");
        VolumeDensityScale = Shader.PropertyToID("vol_density_scale");
        VolumeBBMin = Shader.PropertyToID("vol_bb_min");
        VolumeBBMax = Shader.PropertyToID("vol_bb_max");
        VolumeDensityTransform = Shader.PropertyToID("vol_density_transform");
        VolumeDensityInverseTransform = Shader.PropertyToID("vol_density_inv_transform");

        MipRangeFixed = Shader.PropertyToID("mip_range_fixed");

        TransferFunctionBufferLut = Shader.PropertyToID("tf_lut");
        TransferFunctionBufferSize = Shader.PropertyToID("tf_size");
        TransferFunctionWindowLeft = Shader.PropertyToID("tf_window_left");
        TransferFunctionWindowWidth = Shader.PropertyToID("tf_window_width");

        EnvironmentMap = Shader.PropertyToID("_EnvMap");
        EnvironmentImportanceMap = Shader.PropertyToID("_EnvImpMap");
        EnvironmentStrength = Shader.PropertyToID("env_strength");
        EnvironmentImportanceInverseDimension = Shader.PropertyToID("env_imp_inv_dim");
        EnvironmentImportanceBaseMip = Shader.PropertyToID("env_imp_base_mip");

        LightWorldPos = Shader.PropertyToID("light_world_pos");
        LightWorldDir = Shader.PropertyToID("light_world_dir");
    }
}
