using System;
using System.Collections;
using System.Collections.Generic;
using Unity.Mathematics;
using UnityEngine;

public class PerfTracker : MonoBehaviour
{
    private PerfEval perfEval;
    [SerializeField] private int sampleCount = 1000;
    [SerializeField] private float mean;
    [SerializeField] private float stdev;


    private void Start()
    {
        perfEval = new PerfEval(sampleCount);
    }

    void Update()
    {
        perfEval.AddSample(Time.deltaTime);
        mean = perfEval.Mean();
        stdev = perfEval.Stdev();
    }
}

public class PerfEval
{
    private float[] samples;
    private int currentIndex = 0;
    private int sampleCount = 0;

    public PerfEval(int size)
    {
        this.samples = new float[size];
    }

    public void AddSample(float time)
    {
        samples[currentIndex] = time;
        if (sampleCount < samples.Length)
        {
            ++sampleCount;
        }

        if (currentIndex >= samples.Length - 1)
        {
            currentIndex = 0;
        }
        else
        {
            ++currentIndex;
        }
    }

    public float Mean()
    {
        float val = 0;
        for (int i = 0; i < sampleCount; ++i)
        {
            val += samples[i] / sampleCount;
        } 
        return val;
    }

    public float Stdev()
    {
        float mean = Mean();
        float variance = 0;
        for (int i = 0; i < sampleCount; ++i)
        {
            float val = samples[i] - mean;
            variance += val * val / sampleCount;
        }

        return math.sqrt(variance);
    }
}