using System;
using System.Collections.Generic;
using UnityEngine;

[ExecuteAlways]
public class MainThreadDispatcher : MonoBehaviour
{
    private readonly object locker = new object();
    private Action action = null;
    
    private int numberOfUpdates = 0;

    private void Update()
    {
        lock (locker)
        {
            if (action == null)
            {
                numberOfUpdates++;
                if (numberOfUpdates > 50)
                {
                    Debug.LogError($"MainThreadDispatcher never recieved import task. There is likely some problem with importing DICOM files. Are the binaries installed? Aborting.");
                    Cancel();
                }
                else
                {
                    Debug.Log($"Waiting for import task...");
                }
                return;
            }
            action.Invoke();
        }
        DestroyImmediate(gameObject);
    }

    public void Dispatch(Action dispatched)
    {
        lock (locker)
        {
            action = dispatched;
        }
    }

    public void Cancel()
    {
        Dispatch(() => { });
    }
}
