//from ChatGPT
Shader "Hidden/VolumeOverlay"
{
    Properties
    {
        _MainTex ("Base (Camera)", 2D) = "white" {}
        _VolumeTex ("Volume Output", 2D) = "black" {}
    }
    SubShader
    {
        Tags { "RenderType"="Opaque" }
        Pass
        {
            ZTest Always Cull Off ZWrite Off
            Blend SrcAlpha OneMinusSrcAlpha

            CGPROGRAM
            #pragma vertex vert_img
            #pragma fragment frag
            #include "UnityCG.cginc"

            sampler2D _MainTex;
            sampler2D _VolumeTex;

            fixed4 frag(v2f_img i) : SV_Target
            {
                fixed4 baseColor = tex2D(_MainTex, i.uv);
                fixed4 volumeColor = tex2D(_VolumeTex, i.uv);

                // Alpha blend
                return lerp(baseColor, volumeColor, volumeColor.a);
            }
            ENDCG
        }
    }
}
