using Unity.Mathematics;
using UnityEditor;
using UnityEngine;

public class TestVolume
{
    const uint size = 256;
    
    [MenuItem("Volume Rendering/Create Test Volume")]
    private static void CreateTestVolume()
    {
        try
        {
            var rawData = new Buf3D<float>(new uint3(size, size, size));
            var dims = Vector3.one * (size / 2f);
            var maxDist = dims.sqrMagnitude;
            for (uint z = 0; z < rawData.Dimensions.z; ++z)
            {
                EditorUtility.DisplayProgressBar("Creating Test Volume", $"Filling data in {size}x{size}x{size} Test Volume.", (float)z / size);

                for (uint y = 0; y < rawData.Dimensions.y; ++y)
                {
                    for (uint x = 0; x < rawData.Dimensions.x; ++x)
                    {
                        var distanceToMid = new Vector3(x, y, z) - dims;
                        rawData[new uint3(x, y, z)] = ((maxDist - distanceToMid.sqrMagnitude) / maxDist) * (VolumeData.MAX_HOUNSFIELD - VolumeData.MIN_HOUNSFIELD) + VolumeData.MIN_HOUNSFIELD;
                    }
                }
            }
            
            EditorUtility.DisplayProgressBar("Creating Test Volume", $"Building Textures.", 1.0f);            

            var volumeData = ScriptableObject.CreateInstance<VolumeData>();
            volumeData.Init(rawData, "TestVolume", Vector3.one);            
            volumeData.BuildTextures(
                VolumeFormat.Indirect,
                RangeFormat.Float,
                AtlasFormat.Half,
                IndirectionFormat.Float,
                3,
                false,
                true,
                true);

            Debug.Log("Finished creating test volume.");
        }
        finally
        {
            EditorUtility.ClearProgressBar();
        }
    }
}
