using UnityEngine;
using UnityEditor;
using UnityEditor.ShortcutManagement;

//adapted from https://github.com/sirgru/Unity-Simple-Editor-Shortcuts-Tools-Collection/tree/master
public class MultiObjectRenameWizard : ScriptableWizard
{
    public string oldToken;
    public string newToken;

    [Shortcut("Edit/Multi-Object Rename Wizard", KeyCode.W, ShortcutModifiers.Alt)]
    public static void CreateWizard()
    {
        MultiObjectRenameWizard sw = DisplayWizard("Multi-Object Rename Wizard", typeof(MultiObjectRenameWizard), "Rename") as MultiObjectRenameWizard;
        sw.minSize = sw.maxSize = new Vector2(400, 135);
        
        sw.oldToken = Selection.activeGameObject.name;
        sw.newToken = Selection.activeGameObject.name;
    }

    private void OnWizardCreate()
    {
        foreach (var selectedObject in Selection.gameObjects)
        {
            string objName = selectedObject.name;
            if (objName.Contains(oldToken))
            {
                Undo.RecordObject(selectedObject, "Multi-Object Rename Wizard");
                selectedObject.name = objName.Replace(oldToken, newToken);
            }
        }
    }

    void OnWizardUpdate()
    {
        if (string.IsNullOrEmpty(oldToken)) isValid = false;
        else isValid = true;
    }
}
