using UnityEngine;

[CreateAssetMenu(menuName = "Utility/Debug Utility")]
public class DebugUtility : ScriptableObject
{
    public void Log(string message)
    {
        Debug.Log(message);
    }

    public void LogWarning(string message)
    {
        Debug.LogWarning(message);
    }

    public void LogError(string message)
    {
        Debug.LogError(message);
    }
    
    public void Log(Object unityObject)
    {
        Debug.Log(unityObject.name, unityObject);
    }

    public void LogWarning(Object unityObject)
    {
        Debug.LogWarning(unityObject.name, unityObject);
    }

    public void LogError(Object unityObject)
    {
        Debug.LogError(unityObject.name, unityObject);
    }
}